using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Outbound_OpenInterface_Test_App.OutboundCampaignWS;
using System.Web.Services.Protocols;

namespace Outbound_OpenInterface_Test_App
{
  public partial class Get_Contact_Status : Form
  {
    OWCampaigns This_Campaign_List;
    int This_Selected_Index;

    public Get_Contact_Status(OWCampaigns Campaign_List, int Selected_Index)
    {
      InitializeComponent();
      This_Campaign_List = Campaign_List;
      This_Selected_Index = Selected_Index;
      Campaign_Name_Field.Text = This_Campaign_List.CampaignList[This_Selected_Index].Name;
    }

    /// <summary>
    /// Get Status by contact ID
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Get_By_ID_Button_Click(object sender, EventArgs e)
    {
      try
      {
        //clear msg field
        Message_Label.Text = "";

        //get camapign id
        long campaignID = This_Campaign_List.CampaignList[This_Selected_Index].ID;

        OutboundContactWS.OutboundContactWS contInvoke = new OutboundContactWS.OutboundContactWS();
        OutboundContactWS.OWStatus ReturnVal = new Outbound_OpenInterface_Test_App.OutboundContactWS.OWStatus();
        ReturnVal = contInvoke.GetContactStatus(GlobalDef.getInstance().MySessionKey, System.Convert.ToInt32(Contact_ID_Field.Text), System.Convert.ToInt32(campaignID), "", "", false);
        if(ReturnVal != null)
        {
          if(ReturnVal.Name != null)
            Message_Label.Text = "Status = " + ReturnVal.Name;
        }
        else
          Message_Label.Text = "Error";
      }
      catch(SoapException ex)
      {
        Message_Label.Text = "Error";
      }
    }

    /// <summary>
    /// Get Status by custom Field
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Get_By_CF_Button_Click(object sender, EventArgs e)
    {
      try
      {
        //clear msg field
        Message_Label.Text = "";

        //get camapign id
        long campaignID = This_Campaign_List.CampaignList[This_Selected_Index].ID;

        OutboundContactWS.OutboundContactWS contInvoke = new OutboundContactWS.OutboundContactWS();
        OutboundContactWS.OWStatus ReturnVal = new Outbound_OpenInterface_Test_App.OutboundContactWS.OWStatus();
        ReturnVal = contInvoke.GetContactStatus(GlobalDef.getInstance().MySessionKey, System.Convert.ToInt32(Contact_ID_Field.Text), System.Convert.ToInt32(campaignID), Custom_Name_Field.Text, Custom_Value_Field.Text, true);
        if(ReturnVal != null)
        {
          if(ReturnVal.Name != null)
            Message_Label.Text = "Status = " + ReturnVal.Name;
        }
        else
          Message_Label.Text = "Error";
      }
      catch(SoapException ex)
      {
        Message_Label.Text = "Error";
      }
    }
  }
}